#ifndef __CSliderArray__
#define __CSliderArray__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CSliderArray CSliderArray.hpp
			 * @brief Represents a slider array
			 *
			 * @date 31/05/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @see CSlider
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CSliderArray.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CSliderArray : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				// Construction
				CSliderArray(IControlRoot *root, const long uniqueId, const CRect &area, const long widthOfSlider, const long sliderGap, const long numberOfSliders, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CSliderArray();

//	===========================================================================

				/**
				 * Set the vlaue of a slider
				 * @param value The value of the slider (0 - 1)
				 * @param index The index of the slider to set
				 */
				virtual void setValue(const double value, const long index);

				/**
				 * Get the value of a slider
				 * @param index The index of the slider to get
				 * @retval double The value ofthe slider in range 0 - 1
				 */
				virtual double getValue(const long index) const { return m_sliderValues[index]; }

				/**
				 * Get last moved index
				 * @retval long The index of the last moved slider, default 0 
				 */
				virtual long getIndexOfLastMovedSlider() const { return m_lastIndex; }

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Set the colours
				 * @param frameColour The colour of the frame
				 * @param backgroundColour The background colour of the control
				 * @param handleColour The colour of the area that can be grabbed by the user
				 * @param handleDownColour The colour of the area that can be grabbed by the user when mouse is grabbing it
				 */
				virtual void setColours(CAlphaColour frameColour, CAlphaColour backgroundColour, CAlphaColour handleColour, CAlphaColour handleDownColour);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle the mouse leaving the window area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Draw the sliders
				 * @param graphics The graphics context
				 */
				void drawSliders(CGraphics &graphics);

				/**
				 * Create the sliders
				 * @param widthOfSlider The size of each slider
				 * @param sliderGap The gap between each slider
				 */
				void createSliders(const long widthOfSlider, const long sliderGap);

//	===========================================================================

				CAlphaColour m_handleColour;				/**< Colour of the slider */
				CAlphaColour m_handleDownColour;			/**< Colour of the slider when mouse is down */

				double *m_sliderValues;						/**< The values each slider holds */
				long m_numberOfSliders;						/**< How many sliders are there? */
				CRect *m_sliders;							/**< The actual slider areas */
				long m_widthOfSlider;						/**< Width of the sliders */
				long m_sliderGap;							/**< Gaps between sliders */

				bool m_isDragging;							/**< Are we dragging the slider */
				long m_dragIndex;							/**< Which slider are we dragging? */
				long m_lastIndex;							/**< Index of last thing moved */
			};
		}
	}
}
#endif	// End of CSliderArray.hpp